(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     36440,        856]*)
(*NotebookOutlinePosition[     37094,        879]*)
(*  CellTagsIndexPosition[     37050,        875]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
    \(h[x_] = 3  x^5 + 5  x^3 - 30  x\)], "Input"],

Cell[BoxData[
    \(\(-30\)\ x + 5\ x\^3 + 3\ x\^5\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(A = 
      Plot[h[x], {x, \(-3\), 3}, PlotStyle -> {Thickness[0.004]}, 
        AxesStyle \[Rule] {Thickness[0.003]}, Ticks \[Rule] None, 
        PlotRange \[Rule] {{\(-3.5\), 3.5}, {\(-35\), 35}}, 
        AspectRatio \[Rule] 1/1.4]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .71429 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.142857 0.357143 0.0102041 [
[ -0.0015 -0.0015 0 0 ]
[ 1.0015 .71579 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.003 w
[ ] 0 setdash
0 .35714 m
1 .35714 L
s
.5 0 m
.5 .71429 L
s
0 0 m
1 0 L
1 .71429 L
0 .71429 L
closepath
clip
newpath
.004 w
.24104 0 m
.2494 .11027 L
.26726 .28387 L
.27637 .3529 L
.28618 .41432 L
.29536 .46106 L
.30376 .49569 L
.31174 .52211 L
.32023 .54411 L
.32488 .55369 L
.3291 .56099 L
.33338 .56716 L
.33732 .57178 L
.34193 .57598 L
.34436 .57769 L
.34692 .57915 L
.34916 .58013 L
.35124 .58082 L
.35243 .58112 L
.35352 .58133 L
.35413 .58142 L
.35478 .58151 L
.3554 .58156 L
.35597 .5816 L
.35703 .58163 L
.35815 .58161 L
.3591 .58155 L
.36014 .58143 L
.36127 .58126 L
.36247 .58101 L
.36464 .58042 L
.36683 .57963 L
.3689 .57872 L
.37277 .57658 L
.38167 .56978 L
.39131 .55977 L
.4092 .53544 L
.42814 .50365 L
.46224 .43708 L
.49854 .36026 L
.53348 .28607 L
.57063 .21286 L
.5892 .18132 L
.60642 .15722 L
.61501 .14767 L
.62309 .14055 L
.62757 .13749 L
.62992 .13616 L
.6324 .13498 L
.6345 .13415 L
Mistroke
.6368 .13345 L
.63781 .13321 L
.63889 .133 L
.63991 .13285 L
.64084 .13274 L
.6419 .13267 L
.6429 .13265 L
.644 .13268 L
.64518 .13278 L
.64635 .13293 L
.64694 .13304 L
.64758 .13317 L
.64978 .13377 L
.65186 .13457 L
.65407 .13566 L
.65805 .1383 L
.6631 .14295 L
.66785 .14877 L
.67675 .16377 L
.68552 .18441 L
.69479 .21338 L
.71141 .28677 L
.71993 .33675 L
.72907 .4011 L
.74556 .54944 L
Mfstroke
.74556 .54944 m
.75907 .71429 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{287.313, 205.25},
  ImageMargins->{{43, 0}, {0, 9}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004O0000cA000`40O003h00Oogoo87oo0015Ool0
0`00Oomoo`17Ool00`00Oomoo`2=Ool004Eoo`03001oogoo04Moo`03001oogoo08eoo`00AGoo00<0
07ooOol0Agoo00<007ooOol0SGoo0015Ool00`00Oomoo`17Ool00`00Oomoo`2=Ool004Eoo`03001o
ogoo04Moo`03001oogoo08eoo`00AGoo00<007ooOol0Agoo00<007ooOol0SGoo0015Ool00`00Oomo
o`17Ool00`00Oomoo`2=Ool004Eoo`03001oogoo04Moo`03001oogoo08eoo`00AWoo00<007ooOol0
AWoo00<007ooOol0SGoo0016Ool00`00Oomoo`16Ool00`00Oomoo`2=Ool004Ioo`03001oogoo04Io
o`03001oogoo08eoo`00AWoo00<007ooOol0AWoo00<007ooOol0SGoo0016Ool00`00Oomoo`16Ool0
0`00Oomoo`2=Ool004Ioo`03001oogoo04Ioo`03001oogoo08eoo`00AWoo00<007ooOol0AWoo00<0
07ooOol0SGoo0016Ool00`00Oomoo`16Ool00`00Oomoo`2=Ool004Ioo`03001oogoo04Ioo`03001o
ogoo08eoo`00AWoo00<007ooOol0AWoo00<007ooOol0SGoo0016Ool00`00Oomoo`16Ool00`00Oomo
o`2=Ool004Ioo`03001oogoo04Ioo`03001oogoo08eoo`00AWoo00<007ooOol0AWoo00<007ooOol0
SGoo0016Ool00`00Oomoo`16Ool00`00Oomoo`2=Ool004Ioo`03001oogoo04Ioo`03001oogoo08eo
o`00AWoo00<007ooOol0AWoo00<007ooOol0SGoo0017Ool00`00Oomoo`15Ool00`00Oomoo`2=Ool0
04Moo`03001oogoo04Eoo`03001oogoo08eoo`00Agoo00<007ooOol0AGoo00<007ooOol0SGoo0017
Ool00`00Oomoo`15Ool00`00Oomoo`2=Ool004Moo`03001oogoo04Eoo`03001oogoo08eoo`00Agoo
00<007ooOol0AGoo00<007ooOol0SGoo0017Ool00`00Oomoo`15Ool00`00Oomoo`2=Ool004Moo`03
001oogoo04Eoo`03001oogoo08eoo`00Agoo00<007ooOol0AGoo00<007ooOol0SGoo0017Ool00`00
Oomoo`15Ool00`00Oomoo`2=Ool004Moo`03001oogoo04Eoo`03001oogoo08eoo`00Agoo00<007oo
Ool0AGoo00<007ooOol0SGoo0017Ool00`00Oomoo`15Ool00`00Oomoo`2=Ool004Qoo`03001oogoo
04Aoo`03001oogoo02Eoo`8006Ioo`00B7oo00<007ooOol0A7oo00<007ooOol08Woo0`0000=oo`00
00000P00Hgoo0018Ool00`00Oomoo`14Ool00`00Oomoo`0QOol00`00Oomoo`06Ool00`00Oomoo`1P
Ool004Qoo`03001oogoo04Aoo`03001oogoo021oo`03001oogoo00Qoo`03001oogoo05moo`00B7oo
00<007ooOol0A7oo00<007ooOol07Woo0P0037oo00<007ooOol0GWoo0018Ool00`00Oomoo`14Ool0
0`00Oomoo`0MOol00`00Oomoo`0<Ool00`00Oomoo`1NOol004Qoo`03001oogoo04Aoo`03001oogoo
01aoo`03001oogoo00ioo`03001oogoo05eoo`00B7oo00<007ooOol0A7oo00<007ooOol06goo00<0
07ooOol047oo00<007ooOol0G7oo0018Ool00`00Oomoo`14Ool00`00Oomoo`0JOol00`00Oomoo`0A
Ool00`00Oomoo`1LOol004Qoo`03001oogoo04Aoo`03001oogoo01Yoo`03001oogoo019oo`03001o
ogoo05]oo`00BGoo00<007ooOol0@goo00<007ooOol06Goo00<007ooOol04goo00<007ooOol0Fgoo
0019Ool00`00Oomoo`13Ool00`00Oomoo`0HOol00`00Oomoo`0EOol00`00Oomoo`1JOol004Uoo`03
001oogoo04=oo`03001oogoo01Moo`03001oogoo01Ioo`03001oogoo05Yoo`00BGoo00<007ooOol0
@goo00<007ooOol05goo00<007ooOol05Woo00<007ooOol0FWoo0019Ool00`00Oomoo`13Ool00`00
Oomoo`0FOol00`00Oomoo`0HOol00`00Oomoo`1IOol004Uoo`03001oogoo04=oo`03001oogoo01Eo
o`03001oogoo01Uoo`03001oogoo05Uoo`00BGoo00<007ooOol0@goo00<007ooOol05Goo00<007oo
Ool06Goo00<007ooOol0FGoo0019Ool00`00Oomoo`13Ool00`00Oomoo`0DOol00`00Oomoo`0KOol0
0`00Oomoo`1HOol004Uoo`03001oogoo04=oo`03001oogoo01Aoo`03001oogoo01]oo`03001oogoo
05Qoo`00BGoo00<007ooOol0@goo00<007ooOol04goo00<007ooOol07Goo00<007ooOol0Egoo001:
Ool00`00Oomoo`12Ool00`00Oomoo`0COol00`00Oomoo`0MOol00`00Oomoo`1GOol004Yoo`03001o
ogoo049oo`03001oogoo019oo`03001oogoo01ioo`03001oogoo05Moo`00BWoo00<007ooOol0@Woo
00<007ooOol04Woo00<007ooOol07goo00<007ooOol0EWoo001:Ool00`00Oomoo`12Ool00`00Oomo
o`0AOol00`00Oomoo`0POol00`00Oomoo`1FOol004Yoo`03001oogoo049oo`03001oogoo011oo`03
001oogoo025oo`03001oogoo05Ioo`00BWoo00<007ooOol0@Woo00<007ooOol047oo00<007ooOol0
8Goo00<007ooOol0EWoo001:Ool00`00Oomoo`12Ool00`00Oomoo`0?Ool00`00Oomoo`0SOol00`00
Oomoo`1EOol004Yoo`03001oogoo049oo`03001oogoo00moo`03001oogoo02=oo`03001oogoo05Eo
o`00BWoo00<007ooOol0@Woo00<007ooOol03Woo00<007ooOol097oo00<007ooOol0EGoo001:Ool0
0`00Oomoo`12Ool00`00Oomoo`0>Ool00`00Oomoo`0TOol00`00Oomoo`1EOol004]oo`03001oogoo
045oo`03001oogoo00eoo`03001oogoo02Ioo`03001oogoo05Aoo`00Bgoo00<007ooOol0@Goo00<0
07ooOol03Goo00<007ooOol09Woo00<007ooOol0E7oo001;Ool00`00Oomoo`11Ool00`00Oomoo`0<
Ool00`00Oomoo`0WOol00`00Oomoo`1DOol004]oo`03001oogoo045oo`03001oogoo00aoo`03001o
ogoo02Moo`03001oogoo05Aoo`00Bgoo00<007ooOol0@Goo00<007ooOol02goo00<007ooOol0:Goo
00<007ooOol0Dgoo001;Ool00`00Oomoo`11Ool00`00Oomoo`0;Ool00`00Oomoo`0YOol00`00Oomo
o`1COol004]oo`03001oogoo045oo`03001oogoo00Yoo`03001oogoo02Yoo`03001oogoo05=oo`00
Bgoo00<007ooOol0@Goo00<007ooOol02Woo00<007ooOol0:Woo00<007ooOol0Dgoo001;Ool00`00
Oomoo`11Ool00`00Oomoo`09Ool00`00Oomoo`0/Ool00`00Oomoo`1BOol004]oo`03001oogoo045o
o`03001oogoo00Uoo`03001oogoo02aoo`03001oogoo059oo`00C7oo00<007ooOol0@7oo00<007oo
Ool027oo00<007ooOol0;Goo00<007ooOol0DWoo001<Ool00`00Oomoo`10Ool00`00Oomoo`08Ool0
0`00Oomoo`0]Ool00`00Oomoo`1BOol004aoo`03001oogoo041oo`03001oogoo00Moo`03001oogoo
02moo`03001oogoo055oo`00C7oo00<007ooOol0@7oo00<007ooOol01goo00<007ooOol0;goo00<0
07ooOol0DGoo001<Ool00`00Oomoo`10Ool00`00Oomoo`06Ool00`00Oomoo`0`Ool00`00Oomoo`1A
Ool004aoo`03001oogoo041oo`03001oogoo00Ioo`03001oogoo031oo`03001oogoo055oo`00C7oo
00<007ooOol0@7oo00<007ooOol01Goo00<007ooOol0<Goo00<007ooOol0DGoo001<Ool00`00Oomo
o`10Ool00`00Oomoo`05Ool00`00Oomoo`0aOol00`00Oomoo`1AOol004eoo`03001oogoo03moo`03
001oogoo00Aoo`03001oogoo03=oo`03001oogoo051oo`00CGoo00<007ooOol0?goo00<007ooOol0
17oo00<007ooOol0<goo00<007ooOol0D7oo001=Ool00`00Oomoo`0oOol00`00Oomoo`03Ool00`00
Oomoo`0dOol00`00Oomoo`1@Ool004eoo`03001oogoo03moo`03001oogoo00=oo`03001oogoo03Ao
o`03001oogoo051oo`00CGoo00<007ooOol0?goo00<007ooOol00Woo00<007ooOol0=Goo00<007oo
Ool0D7oo001=Ool00`00Oomoo`0oOol00`00Oomoo`02Ool00`00Oomoo`0eOol00`00Oomoo`1@Ool0
04ioo`03001oogoo03ioo`05001oogooOol0000hOol00`00Oomoo`1@Ool004ioo`03001oogoo03io
o`05001oogooOol0000hOol00`00Oomoo`1@Ool004ioo`03001oogoo03ioo`04001oogoo000jOol0
0`00Oomoo`1?Ool004ioo`03001oogoo03ioo`04001oogoo000jOol00`00Oomoo`1?Ool004ioo`03
001oogoo03ioo`03001oo`0003]oo`03001oogoo04moo`00CWoo00<007ooOol0?Woo00<007oo0000
>goo00<007ooOol0Cgoo001?Ool00`00Oomoo`0mOol2000lOol00`00Oomoo`1?Ool004moo`03001o
ogoo03eoo`8003aoo`03001oogoo04moo`00Cgoo00<007ooOol0?Goo00<007ooOol0>goo00<007oo
Ool0Cgoo001?Ool00`00Oomoo`0mOol00`00Oomoo`0lOol00`00Oomoo`1>Ool00?l001l0005oo`00
Cgoo00<007ooOol0?7oo0P00?Woo00<007ooOol0CWoo001?Ool00`00Oomoo`0lOol2000nOol00`00
Oomoo`1>Ool0051oo`03001oogoo03Yoo`03001oo`0003ioo`03001oogoo04ioo`00D7oo00<007oo
Ool0>Woo00<007oo0000?Woo00<007ooOol0CWoo001@Ool00`00Oomoo`0iOol01000Oomoo`00?goo
00<007ooOol0CGoo001@Ool00`00Oomoo`0iOol01000Oomoo`00?goo00<007ooOol0CGoo001@Ool0
0`00Oomoo`0hOol01@00Oomoogoo0000?goo00<007ooOol0CGoo001@Ool00`00Oomoo`0hOol01@00
Oomoogoo0000?goo00<007ooOol0CGoo001AOol00`00Oomoo`0fOol00`00Oomoo`02Ool00`00Oomo
o`0mOol00`00Oomoo`1=Ool0055oo`03001oogoo03Ioo`03001oogoo009oo`03001oogoo03eoo`03
001oogoo04eoo`00DGoo00<007ooOol0=Goo00<007ooOol00goo00<007ooOol0?Woo00<007ooOol0
C7oo001AOol00`00Oomoo`0eOol00`00Oomoo`03Ool00`00Oomoo`0nOol00`00Oomoo`1<Ool0055o
o`03001oogoo03Eoo`03001oogoo00=oo`03001oogoo03ioo`03001oogoo04aoo`00DGoo00<007oo
Ool0=7oo00<007ooOol017oo00<007ooOol0?Woo00<007ooOol0C7oo001BOol00`00Oomoo`0cOol0
0`00Oomoo`04Ool00`00Oomoo`0nOol00`00Oomoo`1<Ool0059oo`03001oogoo039oo`03001oogoo
00Eoo`03001oogoo03ioo`03001oogoo04aoo`00DWoo00<007ooOol0<Woo00<007ooOol01Goo00<0
07ooOol0?Woo00<007ooOol0C7oo001BOol00`00Oomoo`0aOol00`00Oomoo`06Ool00`00Oomoo`0o
Ool00`00Oomoo`1;Ool0059oo`03001oogoo035oo`03001oogoo00Ioo`03001oogoo03moo`03001o
ogoo04]oo`00DWoo00<007ooOol0<7oo00<007ooOol01goo00<007ooOol0?goo00<007ooOol0Bgoo
001COol00`00Oomoo`0_Ool00`00Oomoo`07Ool00`00Oomoo`0oOol00`00Oomoo`1;Ool005=oo`03
001oogoo02ioo`03001oogoo00Qoo`03001oogoo03moo`03001oogoo04]oo`00Dgoo00<007ooOol0
;Woo00<007ooOol027oo00<007ooOol0?goo00<007ooOol0Bgoo001COol00`00Oomoo`0]Ool00`00
Oomoo`09Ool00`00Oomoo`0oOol00`00Oomoo`1;Ool005=oo`03001oogoo02eoo`03001oogoo00Uo
o`03001oogoo03moo`03001oogoo04]oo`00Dgoo00<007ooOol0;7oo00<007ooOol02Woo00<007oo
Ool0@7oo00<007ooOol0BWoo001DOol00`00Oomoo`0[Ool00`00Oomoo`0:Ool00`00Oomoo`10Ool0
0`00Oomoo`1:Ool005Aoo`03001oogoo02Yoo`03001oogoo00]oo`03001oogoo041oo`03001oogoo
04Yoo`00E7oo00<007ooOol0:Woo00<007ooOol02goo00<007ooOol0@7oo00<007ooOol0BWoo001D
Ool00`00Oomoo`0YOol00`00Oomoo`0<Ool00`00Oomoo`10Ool00`00Oomoo`1:Ool005Aoo`03001o
ogoo02Uoo`03001oogoo00aoo`03001oogoo041oo`03001oogoo04Yoo`00EGoo00<007ooOol09goo
00<007ooOol03Goo00<007ooOol0@7oo00<007ooOol0BWoo001EOol00`00Oomoo`0WOol00`00Oomo
o`0=Ool00`00Oomoo`10Ool00`00Oomoo`1:Ool005Eoo`03001oogoo02Ioo`03001oogoo00ioo`03
001oogoo041oo`03001oogoo04Yoo`00EGoo00<007ooOol09Woo00<007ooOol03Woo00<007ooOol0
@Goo00<007ooOol0BGoo001FOol00`00Oomoo`0TOol00`00Oomoo`0?Ool00`00Oomoo`11Ool00`00
Oomoo`19Ool005Ioo`03001oogoo02Aoo`03001oogoo00moo`03001oogoo045oo`03001oogoo04Uo
o`00EWoo00<007ooOol08goo00<007ooOol047oo00<007ooOol0@Goo00<007ooOol0BGoo001GOol0
0`00Oomoo`0ROol00`00Oomoo`0@Ool00`00Oomoo`11Ool00`00Oomoo`19Ool005Moo`03001oogoo
025oo`03001oogoo015oo`03001oogoo045oo`03001oogoo04Uoo`00Egoo00<007ooOol08Goo00<0
07ooOol04Goo00<007ooOol0@Goo00<007ooOol0BGoo001HOol00`00Oomoo`0OOol00`00Oomoo`0B
Ool00`00Oomoo`11Ool00`00Oomoo`19Ool005Qoo`03001oogoo01ioo`03001oogoo01=oo`03001o
ogoo049oo`03001oogoo04Qoo`00F7oo00<007ooOol07Woo00<007ooOol04goo00<007ooOol0@Woo
00<007ooOol0B7oo001HOol00`00Oomoo`0MOol00`00Oomoo`0DOol00`00Oomoo`12Ool00`00Oomo
o`18Ool005Uoo`03001oogoo01aoo`03001oogoo01Aoo`03001oogoo049oo`03001oogoo04Qoo`00
FGoo00<007ooOol06goo00<007ooOol05Goo00<007ooOol0@Woo00<007ooOol0B7oo001IOol00`00
Oomoo`0KOol00`00Oomoo`0EOol00`00Oomoo`12Ool00`00Oomoo`18Ool005Yoo`03001oogoo01Uo
o`03001oogoo01Ioo`03001oogoo049oo`03001oogoo04Qoo`00FWoo00<007ooOol06Goo00<007oo
Ool05Woo00<007ooOol0@Woo00<007ooOol0B7oo001JOol00`00Oomoo`0HOol00`00Oomoo`0GOol0
0`00Oomoo`13Ool00`00Oomoo`17Ool005Yoo`03001oogoo01Moo`03001oogoo01Qoo`03001oogoo
04=oo`03001oogoo04Moo`00Fgoo00<007ooOol05Woo00<007ooOol067oo00<007ooOol0@goo00<0
07ooOol0Agoo001KOol00`00Oomoo`0EOol00`00Oomoo`0IOol00`00Oomoo`13Ool00`00Oomoo`17
Ool005aoo`03001oogoo01=oo`03001oogoo01Yoo`03001oogoo04=oo`03001oogoo04Moo`00GGoo
00<007ooOol04Goo00<007ooOol06goo00<007ooOol0@goo00<007ooOol0Agoo001NOol00`00Oomo
o`0@Ool00`00Oomoo`0KOol00`00Oomoo`13Ool00`00Oomoo`17Ool005ioo`03001oogoo00moo`03
001oogoo01aoo`03001oogoo04=oo`03001oogoo04Moo`00Ggoo00<007ooOol03Goo00<007ooOol0
7Goo00<007ooOol0@goo00<007ooOol0Agoo001OOol00`00Oomoo`0<Ool00`00Oomoo`0NOol00`00
Oomoo`13Ool00`00Oomoo`17Ool0061oo`03001oogoo00Yoo`03001oogoo01moo`03001oogoo04=o
o`03001oogoo04Moo`00HGoo00<007ooOol01goo0P008Woo00<007ooOol0@goo00<007ooOol0Agoo
001ROol00`00Oomoo`04Ool2000TOol00`00Oomoo`14Ool00`00Oomoo`16Ool006=oo`L002Eoo`03
001oogoo04Aoo`03001oogoo04Ioo`00Sgoo00<007ooOol0A7oo00<007ooOol0AWoo002?Ool00`00
Oomoo`14Ool00`00Oomoo`16Ool008moo`03001oogoo04Aoo`03001oogoo04Ioo`00Sgoo00<007oo
Ool0A7oo00<007ooOol0AWoo002?Ool00`00Oomoo`14Ool00`00Oomoo`16Ool008moo`03001oogoo
04Aoo`03001oogoo04Ioo`00Sgoo00<007ooOol0A7oo00<007ooOol0AWoo002?Ool00`00Oomoo`14
Ool00`00Oomoo`16Ool008moo`03001oogoo04Aoo`03001oogoo04Ioo`00Sgoo00<007ooOol0A7oo
00<007ooOol0AWoo002?Ool00`00Oomoo`14Ool00`00Oomoo`16Ool008moo`03001oogoo04Aoo`03
001oogoo04Ioo`00Sgoo00<007ooOol0A7oo00<007ooOol0AWoo002?Ool00`00Oomoo`14Ool00`00
Oomoo`16Ool008moo`03001oogoo04Eoo`03001oogoo04Eoo`00Sgoo00<007ooOol0AGoo00<007oo
Ool0AGoo002?Ool00`00Oomoo`15Ool00`00Oomoo`15Ool008moo`03001oogoo04Eoo`03001oogoo
04Eoo`00Sgoo00<007ooOol0AGoo00<007ooOol0AGoo002?Ool00`00Oomoo`15Ool00`00Oomoo`15
Ool008moo`03001oogoo04Eoo`03001oogoo04Eoo`00Sgoo00<007ooOol0AGoo00<007ooOol0AGoo
002?Ool00`00Oomoo`15Ool00`00Oomoo`15Ool008moo`03001oogoo04Eoo`03001oogoo04Eoo`00
Sgoo00<007ooOol0AGoo00<007ooOol0AGoo002?Ool00`00Oomoo`15Ool00`00Oomoo`15Ool008mo
o`03001oogoo04Eoo`03001oogoo04Eoo`00Sgoo00<007ooOol0AGoo00<007ooOol0AGoo002?Ool0
0`00Oomoo`15Ool00`00Oomoo`15Ool008moo`03001oogoo04Eoo`03001oogoo04Eoo`00Sgoo00<0
07ooOol0AWoo00<007ooOol0A7oo002?Ool00`00Oomoo`16Ool00`00Oomoo`14Ool008moo`03001o
ogoo04Ioo`03001oogoo04Aoo`00Sgoo00<007ooOol0AWoo00<007ooOol0A7oo002?Ool00`00Oomo
o`16Ool00`00Oomoo`14Ool008moo`03001oogoo04Ioo`03001oogoo04Aoo`00Sgoo00<007ooOol0
AWoo00<007ooOol0A7oo002?Ool00`00Oomoo`16Ool00`00Oomoo`14Ool00001\
\>"],
  ImageRangeCache->{{{0, 286.313}, {204.25, 0}} -> {-3.51922, -35.1473, \
0.024583, 0.344162}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(B = {{Dashing[{0.01, 0.01}], 
          Line[{{\(-3\), h[\(-1\)]}, {3, h[\(-1\)]}}]}, {Dashing[{0.01, 
              0.01}], Line[{{\(-3\), h[1]}, {3, h[1]}}]}, {Dashing[{0.01, 
              0.01}], Line[{{\(-3\), h[\(-1\)] - 12}, {3, h[\(-1\)] - 12}}]}, 
        Text[a1, {0.2, h[1] - 3.5}], Text[a2, {0.2, h[\(-1\)] + 3}], 
        Text[a3, {\(-1\), \(-3.5\)}], Text[a4, {1, \(-3.5\)}], 
        Text[a5, {2, h[\(-1\)] - 9}]}\)], "Input"],

Cell[BoxData[
    \({{Dashing[{0.01`, 0.01`}], 
        Line[{{\(-3\), 22}, {3, 22}}]}, {Dashing[{0.01`, 0.01`}], 
        Line[{{\(-3\), \(-22\)}, {3, \(-22\)}}]}, {Dashing[{0.01`, 0.01`}], 
        Line[{{\(-3\), 10}, {3, 10}}]}, Text[a1, {0.2`, \(-25.5`\)}], 
      Text[a2, {0.2`, 25}], Text[a3, {\(-1\), \(-3.5`\)}], 
      Text[a4, {1, \(-3.5`\)}], Text[a5, {2, 13}]}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[A, Graphics[B]]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .71429 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.142857 0.357143 0.0102041 [
[ -0.0015 -0.0015 0 0 ]
[ 1.0015 .71579 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.003 w
[ ] 0 setdash
0 .35714 m
1 .35714 L
s
.5 0 m
.5 .71429 L
s
0 0 m
1 0 L
1 .71429 L
0 .71429 L
closepath
clip
newpath
.004 w
.24104 0 m
.2494 .11027 L
.26726 .28387 L
.27637 .3529 L
.28618 .41432 L
.29536 .46106 L
.30376 .49569 L
.31174 .52211 L
.32023 .54411 L
.32488 .55369 L
.3291 .56099 L
.33338 .56716 L
.33732 .57178 L
.34193 .57598 L
.34436 .57769 L
.34692 .57915 L
.34916 .58013 L
.35124 .58082 L
.35243 .58112 L
.35352 .58133 L
.35413 .58142 L
.35478 .58151 L
.3554 .58156 L
.35597 .5816 L
.35703 .58163 L
.35815 .58161 L
.3591 .58155 L
.36014 .58143 L
.36127 .58126 L
.36247 .58101 L
.36464 .58042 L
.36683 .57963 L
.3689 .57872 L
.37277 .57658 L
.38167 .56978 L
.39131 .55977 L
.4092 .53544 L
.42814 .50365 L
.46224 .43708 L
.49854 .36026 L
.53348 .28607 L
.57063 .21286 L
.5892 .18132 L
.60642 .15722 L
.61501 .14767 L
.62309 .14055 L
.62757 .13749 L
.62992 .13616 L
.6324 .13498 L
.6345 .13415 L
Mistroke
.6368 .13345 L
.63781 .13321 L
.63889 .133 L
.63991 .13285 L
.64084 .13274 L
.6419 .13267 L
.6429 .13265 L
.644 .13268 L
.64518 .13278 L
.64635 .13293 L
.64694 .13304 L
.64758 .13317 L
.64978 .13377 L
.65186 .13457 L
.65407 .13566 L
.65805 .1383 L
.6631 .14295 L
.66785 .14877 L
.67675 .16377 L
.68552 .18441 L
.69479 .21338 L
.71141 .28677 L
.71993 .33675 L
.72907 .4011 L
.74556 .54944 L
Mfstroke
.74556 .54944 m
.75907 .71429 L
s
.5 Mabswid
[ .01 .01 ] 0 setdash
.07143 .58163 m
.92857 .58163 L
s
.07143 .13265 m
.92857 .13265 L
s
.07143 .45918 m
.92857 .45918 L
s
gsave
.52857 .09694 -69 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a1) show
1.000 setlinewidth
grestore
gsave
.52857 .61224 -69 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a2) show
1.000 setlinewidth
grestore
gsave
.35714 .32143 -69 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a3) show
1.000 setlinewidth
grestore
gsave
.64286 .32143 -69 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a4) show
1.000 setlinewidth
grestore
gsave
.78571 .4898 -69 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a5) show
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 205.688},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000cA000`40O003h00OAGoo00<007ooOol0
Agoo00<007ooOol0SWoo0015Ool00`00Oomoo`17Ool00`00Oomoo`2>Ool004Eoo`03001oogoo04Mo
o`03001oogoo08ioo`00AGoo00<007ooOol0Agoo00<007ooOol0SWoo0015Ool00`00Oomoo`17Ool0
0`00Oomoo`2>Ool004Eoo`03001oogoo04Moo`03001oogoo08ioo`00AGoo00<007ooOol0Agoo00<0
07ooOol0SWoo0015Ool00`00Oomoo`17Ool00`00Oomoo`2>Ool004Ioo`03001oogoo04Ioo`03001o
ogoo08ioo`00AWoo00<007ooOol0AWoo00<007ooOol0SWoo0016Ool00`00Oomoo`16Ool00`00Oomo
o`2>Ool004Ioo`03001oogoo04Ioo`03001oogoo08ioo`00AWoo00<007ooOol0AWoo00<007ooOol0
SWoo0016Ool00`00Oomoo`16Ool00`00Oomoo`2>Ool004Ioo`03001oogoo04Ioo`03001oogoo08io
o`00AWoo00<007ooOol0AWoo00<007ooOol0SWoo0016Ool00`00Oomoo`16Ool00`00Oomoo`2>Ool0
04Ioo`03001oogoo04Ioo`03001oogoo08ioo`00AWoo00<007ooOol0AWoo00<007ooOol0SWoo0016
Ool00`00Oomoo`16Ool00`00Oomoo`2>Ool004Ioo`03001oogoo04Ioo`03001oogoo08ioo`00AWoo
00<007ooOol0AWoo00<007ooOol0SWoo0016Ool00`00Oomoo`16Ool00`00Oomoo`2>Ool004Ioo`03
001oogoo04Ioo`03001oogoo08ioo`00Agoo00<007ooOol0AGoo00<007ooOol0SWoo0017Ool00`00
Oomoo`15Ool00`00Oomoo`2>Ool004Moo`03001oogoo04Eoo`03001oogoo00D00003Ool0000000<0
08=oo`00Agoo00<007ooOol0AGoo00<007ooOol0100017oo00<007ooOol0Pgoo0017Ool00`00Oomo
o`15Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`23Ool004Moo`03001oogoo04Eoo`04
001oogooOol30004Ool00`00Oomoo`23Ool004Moo`03001oogoo04Eoo`03001oogoo00Qoo`03001o
ogoo08=oo`00Agoo00<007ooOol0AGoo00<007ooOol01goo0P00QGoo0017Ool00`00Oomoo`15Ool0
0`00Oomoo`2>Ool004Moo`03001oogoo04Eoo`03001oogoo08ioo`00Agoo00<007ooOol0AGoo00<0
07ooOol0SWoo0017Ool00`00Oomoo`15Ool00`00Oomoo`2>Ool004Moo`03001oogoo04Eoo`03001o
ogoo08ioo`00B7oo00<007ooOol0A7oo00<007ooOol0SWoo000EOol400000goo000000020002Ool4
0002Ool40002Ool30002Ool40002Ool40002Ool30002Ool40002Ool40002Ool400000goo00000002
0002Ool40002Ool40002Ool30002Ool40002Ool40002Ool400000goo000000020002Ool40002Ool4
0002Ool30002Ool40002Ool40002Ool400000goo000000020002Ool40002Ool400000goo00000008
0002Ool40002Ool30002Ool40002Ool40002Ool400000goo000000020002Ool40002Ool40002Ool3
0002Ool40002Ool40002Ool400000goo00000002000HOol004Qoo`03001oogoo04Aoo`03001oogoo
025oo`<000Aoo`8006Aoo`00B7oo00<007ooOol0A7oo00<007ooOol087oo00<007ooOol01goo0P00
HWoo0018Ool00`00Oomoo`14Ool00`00Oomoo`0OOol00`00Oomoo`0:Ool00`00Oomoo`1OOol004Qo
o`03001oogoo04Aoo`03001oogoo01ioo`03001oogoo00aoo`03001oogoo05ioo`00B7oo00<007oo
Ool0A7oo00<007ooOol07Goo00<007ooOol03Goo00<007ooOol0GWoo0018Ool00`00Oomoo`14Ool0
0`00Oomoo`0LOol00`00Oomoo`0?Ool00`00Oomoo`1MOol004Uoo`03001oogoo04=oo`03001oogoo
01]oo`03001oogoo011oo`03001oogoo05eoo`00BGoo00<007ooOol0@goo00<007ooOol06Woo00<0
07ooOol04Woo00<007ooOol0G7oo0019Ool00`00Oomoo`13Ool00`00Oomoo`0JOol00`00Oomoo`0B
Ool00`00Oomoo`1LOol004Uoo`03001oogoo04=oo`03001oogoo01Uoo`03001oogoo01Aoo`03001o
ogoo05]oo`00BGoo00<007ooOol0@goo00<007ooOol067oo00<007ooOol05Goo00<007ooOol0Fgoo
0019Ool00`00Oomoo`13Ool00`00Oomoo`0GOol00`00Oomoo`0GOol00`00Oomoo`1JOol004Uoo`03
001oogoo04=oo`03001oogoo01Moo`03001oogoo01Moo`03001oogoo05Yoo`00BGoo00<007ooOol0
@goo00<007ooOol05Woo00<007ooOol06Goo00<007ooOol0FGoo001:Ool00`00Oomoo`12Ool00`00
Oomoo`0EOol00`00Oomoo`0JOol00`00Oomoo`1IOol004Yoo`03001oogoo049oo`03001oogoo01Eo
o`03001oogoo01Yoo`03001oogoo05Uoo`00BWoo00<007ooOol0@Woo00<007ooOol057oo00<007oo
Ool077oo00<007ooOol0F7oo001:Ool00`00Oomoo`12Ool00`00Oomoo`0DOol00`00Oomoo`0LOol0
0`00Oomoo`1HOol004Yoo`03001oogoo049oo`03001oogoo01=oo`03001oogoo01ioo`03001oogoo
05Moo`00BWoo00<007ooOol0@Woo00<007ooOol04goo00<007ooOol07Woo00<007ooOol0Egoo001:
Ool00`00Oomoo`12Ool00`00Oomoo`0BOol00`00Oomoo`0OOol00`00Oomoo`1GOol004Yoo`03001o
ogoo049oo`03001oogoo019oo`03001oogoo021oo`03001oogoo05Ioo`00Bgoo00<007ooOol0@Goo
00<007ooOol04Goo00<007ooOol08Goo00<007ooOol0EWoo001;Ool00`00Oomoo`11Ool00`00Oomo
o`0AOol00`00Oomoo`0QOol00`00Oomoo`1FOol004]oo`03001oogoo045oo`03001oogoo011oo`03
001oogoo029oo`03001oogoo05Ioo`00Bgoo00<007ooOol0@Goo00<007ooOol047oo00<007ooOol0
8goo00<007ooOol0EGoo001;Ool00`00Oomoo`11Ool00`00Oomoo`0?Ool00`00Oomoo`0TOol00`00
Oomoo`1EOol004]oo`03001oogoo045oo`03001oogoo00moo`03001oogoo02Aoo`03001oogoo05Eo
o`00Bgoo00<007ooOol0@Goo00<007ooOol03Woo00<007ooOol09Goo00<007ooOol0EGoo001;Ool0
0`00Oomoo`11Ool00`00Oomoo`0>Ool00`00Oomoo`0UOol00`00Oomoo`1EOol004aoo`03001oogoo
041oo`03001oogoo00eoo`03001oogoo02Moo`03001oogoo05Aoo`00C7oo00<007ooOol0@7oo00<0
07ooOol03Goo00<007ooOol09goo00<007ooOol0E7oo001<Ool00`00Oomoo`10Ool00`00Oomoo`0<
Ool00`00Oomoo`0XOol00`00Oomoo`1DOol004aoo`03001oogoo041oo`03001oogoo00aoo`03001o
ogoo02Qoo`03001oogoo05Aoo`00C7oo00<007ooOol0@7oo00<007ooOol02goo00<007ooOol0:Goo
00<007ooOol0E7oo001<Ool00`00Oomoo`10Ool00`00Oomoo`0;Ool00`00Oomoo`0YOol00`00Oomo
o`1DOol004aoo`03001oogoo041oo`03001oogoo00Yoo`03001oogoo02]oo`03001oogoo05=oo`00
C7oo00<007ooOol0@7oo00<007ooOol02Woo00<007ooOol0:goo00<007ooOol0Dgoo001=Ool00`00
Oomoo`0oOol00`00Oomoo`09Ool00`00Oomoo`0/Ool00`00Oomoo`1COol004eoo`03001oogoo03mo
o`03001oogoo00Uoo`03001oogoo02aoo`03001oogoo05=oo`00CGoo00<007ooOol0?goo00<007oo
Ool027oo00<007ooOol0;Goo00<007ooOol0Dgoo001=Ool00`00Oomoo`0oOol00`00Oomoo`08Ool0
0`00Oomoo`0^Ool00`00Oomoo`1BOol004eoo`03001oogoo03moo`03001oogoo00Moo`03001oogoo
02moo`03001oogoo059oo`00CGoo00<007ooOol0?goo00<007ooOol01goo00<007ooOol0;goo00<0
07ooOol0DWoo001=Ool00`00Oomoo`0oOol00`00Oomoo`07Ool00`00Oomoo`0_Ool00`00Oomoo`1B
Ool004eoo`03001oogoo03moo`03001oogoo00Ioo`03001oogoo031oo`03001oogoo059oo`00CGoo
00<007ooOol0?goo00<007ooOol01Woo00<007ooOol0<Goo00<007ooOol0DGoo001=Ool00`00Oomo
o`0oOol00`00Oomoo`05Ool00`00Oomoo`0bOol00`00Oomoo`1AOol004ioo`03001oogoo03ioo`03
001oogoo00Eoo`03001oogoo039oo`03001oogoo055oo`00CWoo00<007ooOol0?Woo00<007ooOol0
17oo00<007ooOol0<goo00<007ooOol0DGoo001>Ool00`00Oomoo`0nOol00`00Oomoo`04Ool00`00
Oomoo`0cOol00`00Oomoo`1AOol004ioo`03001oogoo011oo`D0009oo`8002Eoo`03001oogoo00=o
o`03001oogoo01]oo`D000=oo`<000moo`03001oogoo051oo`00CWoo00<007ooOol047oo10000Woo
00@007ooOol002Aoo`03001oogoo00=oo`03001oogoo01]oo`@000Eoo`03001oogoo00ioo`03001o
ogoo051oo`00CWoo00<007ooOol04goo00<007ooOol00Woo00<007ooOol08goo00<007ooOol00Woo
00<007ooOol07goo00<007ooOol01@003goo00<007ooOol0D7oo001>Ool00`00Oomoo`0AOol30005
Ool00`00Oomoo`0ROol00`00Oomoo`02Ool00`00Oomoo`0MOol30002Ool01000Oomoo`0047oo00<0
07ooOol0D7oo001>Ool00`00Oomoo`0FOol01000Oomoo`0097oo00D007ooOomoo`0002Ioo`03001o
o`00015oo`03001oogoo04moo`00CWoo00<007ooOol05goo0P009Goo00D007ooOomoo`0002Moo`80
015oo`03001oogoo04moo`00CWoo00<007ooOol0?Woo00@007ooOol003]oo`03001oogoo04moo`00
Cgoo00<007ooOol0?Goo00@007ooOol003]oo`03001oogoo04moo`00Cgoo00<007ooOol0?Goo00<0
07oo0000?7oo00<007ooOol0Cgoo001?Ool00`00Oomoo`0mOol00`00Ool0000lOol00`00Oomoo`1?
Ool004moo`03001oogoo03eoo`8003eoo`03001oogoo04moo`00Cgoo00<007ooOol0?Goo0P00?Woo
00<007ooOol0CWoo003o000P0001Ool004moo`03001oogoo03eoo`03001oogoo03eoo`03001oogoo
04ioo`00D7oo00<007ooOol0?7oo00<007ooOol0?Goo00<007ooOol0CWoo001@Ool00`00Oomoo`0k
Ool2000oOol00`00Oomoo`1>Ool0051oo`03001oogoo03]oo`8003moo`03001oogoo04ioo`00D7oo
00<007ooOol0>Woo00<007oo0000?goo00<007ooOol0CWoo001@Ool00`00Oomoo`0jOol00`00Ool0
000oOol00`00Oomoo`1>Ool0051oo`03001oogoo03Uoo`04001oogoo000oOol00`00Oomoo`1>Ool0
055oo`03001oogoo03Qoo`04001oogoo000oOol00`00Oomoo`1>Ool0055oo`03001oogoo03Moo`05
001oogooOol00010Ool00`00Oomoo`1=Ool0055oo`03001oogoo03Moo`05001oogooOol00010Ool0
0`00Oomoo`1=Ool0055oo`03001oogoo03Ioo`03001oogoo009oo`03001oogoo03ioo`03001oogoo
04eoo`00DGoo00<007ooOol0=Woo00<007ooOol00Woo00<007ooOol0?Woo00<007ooOol0CGoo001A
Ool00`00Oomoo`0eOol00`00Oomoo`03Ool00`00Oomoo`0nOol00`00Oomoo`1=Ool0059oo`03001o
ogoo03Aoo`03001oogoo00=oo`03001oogoo03ioo`03001oogoo04eoo`00DWoo00<007ooOol0<goo
00<007ooOol017oo00<007ooOol0?Woo00<007ooOol0CGoo001BOol00`00Oomoo`0cOol00`00Oomo
o`04Ool00`00Oomoo`0nOol00`00Oomoo`1=Ool0059oo`03001oogoo039oo`03001oogoo00Eoo`03
001oogoo03ioo`03001oogoo04eoo`00DWoo00<007ooOol0<Woo00<007ooOol01Goo00<007ooOol0
?goo00<007ooOol0C7oo001COol00`00Oomoo`0`Ool00`00Oomoo`06Ool00`00Oomoo`0oOol00`00
Oomoo`1<Ool005=oo`03001oogoo031oo`03001oogoo00Ioo`03001oogoo03moo`03001oogoo04ao
o`00Dgoo00<007ooOol0;goo00<007ooOol01goo00<007ooOol0?goo00<007ooOol0C7oo001COol0
0`00Oomoo`0_Ool00`00Oomoo`07Ool00`00Oomoo`0oOol00`00Oomoo`1<Ool005=oo`03001oogoo
02ioo`03001oogoo00Qoo`03001oogoo03moo`03001oogoo04aoo`00E7oo00<007ooOol0;7oo00<0
07ooOol02Goo00<007ooOol0?goo00<007ooOol0C7oo001DOol00`00Oomoo`0/Ool00`00Oomoo`09
Ool00`00Oomoo`0oOol00`00Oomoo`1<Ool005Aoo`03001oogoo02]oo`03001oogoo00Yoo`03001o
ogoo041oo`03001oogoo04]oo`00E7oo00<007ooOol0:goo00<007ooOol02Woo00<007ooOol0@7oo
00<007ooOol0Bgoo001EOol00`00Oomoo`0YOol00`00Oomoo`0;Ool00`00Oomoo`10Ool00`00Oomo
o`1;Ool001Eoo`@00003Ool000000080009oo`@0009oo`@0009oo`<0009oo`@0009oo`@0009oo`<0
009oo`@0009oo`@0009oo`@00003Ool000000080009oo`@0009oo`@0009oo`<0009oo`@0009oo`@0
009oo`@00003Ool000000080009oo`@0009oo`@0009oo`<0009oo`@0009oo`@0009oo`@00003Ool0
00000080009oo`@0009oo`@00003Ool000000080009oo`@0009oo`@0009oo`<0009oo`@0009oo`@0
009oo`@00003Ool000000080009oo`@0009oo`@0009oo`<0009oo`@0009oo`@0009oo`@00003Ool0
0000008001Qoo`00EGoo00<007ooOol0:7oo00<007ooOol037oo00<007ooOol0@7oo00<007ooOol0
Bgoo001EOol00`00Oomoo`0XOol00`00Oomoo`0<Ool00`00Oomoo`10Ool00`00Oomoo`1;Ool005Eo
o`03001oogoo02Moo`03001oogoo00eoo`03001oogoo041oo`03001oogoo04]oo`00EWoo00<007oo
Ool09Woo00<007ooOol03Goo00<007ooOol0@7oo00<007ooOol0Bgoo001FOol00`00Oomoo`0UOol0
0`00Oomoo`0>Ool00`00Oomoo`10Ool00`00Oomoo`1;Ool005Ioo`03001oogoo02Eoo`03001oogoo
00ioo`03001oogoo045oo`03001oogoo04Yoo`00EWoo00<007ooOol097oo00<007ooOol03goo00<0
07ooOol0@Goo00<007ooOol01Woo1@000Woo0P00>goo001FOol00`00Oomoo`0TOol00`00Oomoo`0?
Ool00`00Oomoo`11Ool00`00Oomoo`06Ool40002Ool01000Oomoo`00>Woo001GOol00`00Oomoo`0R
Ool00`00Oomoo`0@Ool00`00Oomoo`11Ool00`00Oomoo`09Ool00`00Oomoo`03Ool00`00Oomoo`0h
Ool005Moo`03001oogoo029oo`03001oogoo011oo`03001oogoo045oo`03001oogoo00Moo`<000=o
o`8003]oo`00Egoo00<007ooOol08Goo00<007ooOol04Goo00<007ooOol0@Goo00<007ooOol03Goo
00<007ooOol0>Woo001GOol00`00Oomoo`0QOol00`00Oomoo`0AOol00`00Oomoo`11Ool00`00Oomo
o`0=Ool3000jOol005Qoo`03001oogoo01moo`03001oogoo019oo`03001oogoo045oo`03001oogoo
04Yoo`00F7oo00<007ooOol07Woo00<007ooOol04goo00<007ooOol0@Woo00<007ooOol0BGoo001H
Ool00`00Oomoo`0NOol00`00Oomoo`0COol00`00Oomoo`12Ool00`00Oomoo`19Ool005Qoo`03001o
ogoo01eoo`03001oogoo01Aoo`03001oogoo049oo`03001oogoo04Uoo`00FGoo00<007ooOol077oo
00<007ooOol057oo00<007ooOol0@Woo00<007ooOol0BGoo001IOol00`00Oomoo`0KOol00`00Oomo
o`0EOol00`00Oomoo`12Ool00`00Oomoo`19Ool005Uoo`03001oogoo01]oo`03001oogoo01Eoo`03
001oogoo049oo`03001oogoo04Uoo`00FWoo00<007ooOol06Goo00<007ooOol05Woo00<007ooOol0
@Woo00<007ooOol0BGoo001JOol00`00Oomoo`0IOol00`00Oomoo`0FOol00`00Oomoo`12Ool00`00
Oomoo`19Ool005]oo`03001oogoo01Moo`03001oogoo01Moo`03001oogoo04=oo`03001oogoo04Qo
o`00Fgoo00<007ooOol05Woo00<007ooOol067oo00<007ooOol0@goo00<007ooOol0B7oo001LOol0
0`00Oomoo`0EOol00`00Oomoo`0HOol00`00Oomoo`13Ool00`00Oomoo`18Ool005aoo`03001oogoo
01Aoo`03001oogoo01Uoo`03001oogoo04=oo`03001oogoo04Qoo`00GGoo00<007ooOol04Woo00<0
07ooOol06Woo00<007ooOol0@goo00<007ooOol0B7oo001MOol00`00Oomoo`0AOol00`00Oomoo`0K
Ool00`00Oomoo`13Ool00`00Oomoo`18Ool005ioo`03001oogoo011oo`03001oogoo01]oo`03001o
ogoo04=oo`03001oogoo04Qoo`00GWoo00<007ooOol03goo00<007ooOol077oo00<007ooOol0@goo
00<007ooOol0B7oo001OOol00`00Oomoo`0=Ool00`00Oomoo`0MOol00`00Oomoo`13Ool00`00Oomo
o`18Ool005moo`8000eoo`03001oogoo01ioo`03001oogoo04=oo`03001oogoo04Qoo`00HGoo00<0
07ooOol02Goo00<007ooOol07goo00<007ooOol0A7oo00<007ooOol0Agoo001ROol00`00Oomoo`07
Ool00`00Oomoo`0POol00`00Oomoo`14Ool00`00Oomoo`17Ool0069oo`8000Ioo`8002=oo`03001o
ogoo04Aoo`03001oogoo04Moo`005Goo100000=oo`0000000P000Woo10000Woo10000Woo0`000Woo
10000Woo10000Woo0`000Woo10000Woo10000Woo100000=oo`0000000P000Woo10000Woo3`000Woo
10000Woo100000=oo`0000000P000Woo10000Woo10000Woo0`000Woo10000Woo10000Woo100000=o
o`0000000P000Woo10000Woo100000=oo`0000000P000Woo10000Woo10000Woo0`000Woo10000Woo
100000=oo`0000000`0000=oo`0000000P000Woo10000Woo10000Woo0`000Woo10000Woo10000Woo
100000=oo`0000000P0067oo002?Ool00`00Oomoo`14Ool00`00Oomoo`17Ool008moo`03001oogoo
04Aoo`03001oogoo04Moo`00Sgoo00<007ooOol0A7oo00<007ooOol0Agoo002?Ool00`00Oomoo`14
Ool00`00Oomoo`17Ool008moo`03001oogoo04Aoo`03001oogoo04Moo`00Sgoo00<007ooOol0A7oo
00<007ooOol0Agoo002?Ool00`00Oomoo`0500000goo00000002000jOol00`00Oomoo`17Ool008mo
o`03001oogoo00@0009oo`03001oogoo03]oo`03001oogoo04Moo`00Sgoo00<007ooOol00goo00D0
07ooOomoo`0003eoo`03001oogoo04Ioo`00Sgoo00@007ooOomoo`<000Aoo`03001oogoo03Yoo`03
001oogoo04Ioo`00Sgoo00<007ooOol01Woo00@007ooOol003]oo`03001oogoo04Ioo`00Sgoo00<0
07ooOol01goo0P00?7oo00<007ooOol0AWoo002?Ool00`00Oomoo`15Ool00`00Oomoo`16Ool008mo
o`03001oogoo04Eoo`03001oogoo04Ioo`00Sgoo00<007ooOol0AGoo00<007ooOol0AWoo002?Ool0
0`00Oomoo`15Ool00`00Oomoo`16Ool008moo`03001oogoo04Eoo`03001oogoo04Ioo`00Sgoo00<0
07ooOol0AGoo00<007ooOol0AWoo002?Ool00`00Oomoo`15Ool00`00Oomoo`16Ool008moo`03001o
ogoo04Eoo`03001oogoo04Ioo`00Sgoo00<007ooOol0AWoo00<007ooOol0AGoo002?Ool00`00Oomo
o`16Ool00`00Oomoo`15Ool008moo`03001oogoo04Ioo`03001oogoo04Eoo`00Sgoo00<007ooOol0
AWoo00<007ooOol0AGoo002?Ool00`00Oomoo`16Ool00`00Oomoo`15Ool008moo`03001oogoo04Io
o`03001oogoo04Eoo`00Sgoo00<007ooOol0AWoo00<007ooOol0AGoo002?Ool00`00Oomoo`16Ool0
0`00Oomoo`15Ool008moo`03001oogoo04Ioo`03001oogoo04Eoo`00Sgoo00<007ooOol0AWoo00<0
07ooOol0AGoo002?Ool00`00Oomoo`16Ool00`00Oomoo`15Ool008moo`03001oogoo04Ioo`03001o
ogoo04Eoo`00Sgoo00<007ooOol0Agoo00<007ooOol0A7oo002?Ool00`00Oomoo`17Ool00`00Oomo
o`14Ool008moo`03001oogoo04Moo`03001oogoo04Aoo`00Sgoo00<007ooOol0Agoo00<007ooOol0
A7oo002?Ool00`00Oomoo`17Ool00`00Oomoo`14Ool008moo`03001oogoo04Moo`03001oogoo04Ao
o`00\
\>"],
  ImageRangeCache->{{{0, 287}, {204.688, 0}} -> {-3.52013, -35.1473, \
0.0245305, 0.343426}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Display["\<cubica.eps\>", %, "\<EPS\>"]\)], "Input"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 680}},
WindowSize->{1016, 648},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 64, 1, 30, "Input"],
Cell[1806, 54, 64, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[1907, 60, 267, 5, 50, "Input"],
Cell[2177, 67, 13967, 279, 223, 1912, 126, "GraphicsData", "PostScript", \
"Graphics"],
Cell[16147, 348, 130, 3, 29, "Output"]
}, Open  ]],
Cell[16292, 354, 26, 0, 30, "Input"],

Cell[CellGroupData[{
Cell[16343, 358, 461, 7, 70, "Input"],
Cell[16807, 367, 387, 6, 67, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17231, 378, 53, 1, 30, "Input"],
Cell[17287, 381, 18762, 456, 214, 5071, 282, "GraphicsData", "PostScript", \
"Graphics"],
Cell[36052, 839, 130, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[36219, 847, 72, 1, 30, "Input"],
Cell[36294, 850, 130, 3, 29, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

